/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import io.github.fabricators_of_create.porting_lib.data.ModdedBlockLootSubProvider;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import io.github.fabricators_of_create.porting_lib.tool.loot.CanToolPerformAction;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_101;
import net.minecraft.class_116;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3489;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5651;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_7701;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import net.minecraft.class_94;
import slimeknights.mantle.loot.function.RetexturedLootFunction;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockLootTableProvider
extends ModdedBlockLootSubProvider {
    private static final class_5341.class_210 SILK_TOUCH = class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1))));
    private static final class_5341.class_210 SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    private static final class_5341.class_210 SILK_TOUCH_OR_SHEARS = SHEARS.method_893(SILK_TOUCH);
    private final Function<class_2248, class_52.class_53> ADD_TABLE = block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023)).method_438(RetexturedLootFunction::new));

    protected BlockLootTableProvider() {
        super(Set.of(), class_7701.field_40180.method_45383());
    }

    @Nonnull
    protected Iterable<class_2248> getKnownBlocks() {
        return class_7923.field_41175.method_10220().filter(block -> "tconstruct".equals(class_7923.field_41175.method_10221(block).method_12836())).collect(Collectors.toList());
    }

    public void method_10379() {
        this.addCommon();
        this.addDecorative();
        this.addGadgets();
        this.addWorld();
        this.addTools();
        this.addSmeltery();
        this.addFoundry();
    }

    private void addCommon() {
        this.registerBuildingLootTables(TinkerCommons.blazewood);
        this.registerBuildingLootTables(TinkerCommons.lavawood);
        this.registerFenceBuildingLootTables(TinkerMaterials.nahuatl);
        this.method_46025(TinkerModifiers.silkyJewelBlock.get());
        this.method_46025((class_2248)TinkerCommons.goldBars.get());
        this.method_46025(TinkerCommons.goldPlatform.get());
        this.method_46025(TinkerCommons.ironPlatform.get());
        this.method_46025(TinkerCommons.cobaltPlatform.get());
        TinkerCommons.copperPlatform.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46025(arg_0));
        TinkerCommons.waxedCopperPlatform.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46025(arg_0));
        this.method_46025((class_2248)TinkerMaterials.cobalt.get());
        this.method_46025((class_2248)TinkerMaterials.slimesteel.get());
        this.method_46025((class_2248)TinkerMaterials.amethystBronze.get());
        this.method_46025((class_2248)TinkerMaterials.roseGold.get());
        this.method_46025((class_2248)TinkerMaterials.pigIron.get());
        this.method_46025((class_2248)TinkerMaterials.manyullyn.get());
        this.method_46025((class_2248)TinkerMaterials.hepatizon.get());
        this.method_46025((class_2248)TinkerMaterials.queensSlime.get());
        this.method_46025((class_2248)TinkerMaterials.soulsteel.get());
        this.method_46025((class_2248)TinkerMaterials.knightslime.get());
    }

    private void addDecorative() {
        this.method_46025(TinkerCommons.obsidianPane.get());
        this.method_46025((class_2248)TinkerCommons.clearGlass.get());
        this.method_46025((class_2248)TinkerCommons.clearTintedGlass.get());
        this.method_46025((class_2248)TinkerCommons.clearGlassPane.get());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.method_46025((class_2248)TinkerCommons.clearStainedGlass.get(color));
            this.method_46025((class_2248)TinkerCommons.clearStainedGlassPane.get(color));
        }
        this.method_46025((class_2248)TinkerCommons.soulGlass.get());
        this.method_46025((class_2248)TinkerCommons.soulGlassPane.get());
        this.registerBuildingLootTables(TinkerCommons.mudBricks);
    }

    private void addTools() {
        this.method_45994(TinkerTables.tinkersChest.get(), block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023)).method_438((class_117.class_118)class_3837.method_16848((class_5651)class_5646.field_27914).method_16856("color", "display.color"))));
        this.method_45994(TinkerTables.partChest.get(), block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023))));
        this.method_45994(TinkerTables.castChest.get(), block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023)).method_438((class_117.class_118)class_3837.method_16848((class_5651)class_5646.field_27914).method_16856("Items", "TinkerData.Items"))));
        this.dropTable(TinkerTables.craftingStation.get());
        this.dropTable(TinkerTables.partBuilder.get());
        this.dropTable(TinkerTables.tinkerStation.get());
        this.dropTable(TinkerTables.tinkersAnvil.get());
        this.dropTable(TinkerTables.modifierWorktable.get());
        this.dropTable(TinkerTables.scorchedAnvil.get());
    }

    private void addWorld() {
        this.method_45994(TinkerWorld.cobaltOre.get(), block -> this.method_45981((class_2248)block, TinkerWorld.rawCobalt.method_8389()));
        this.method_46025(TinkerWorld.rawCobaltBlock.get());
        TinkerWorld.heads.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46025(arg_0));
        TinkerWorld.slime.forEach((type, block) -> {
            if (type != SlimeType.EARTH) {
                this.method_46025((class_2248)block);
            }
        });
        TinkerWorld.congealedSlime.forEach((slime, block) -> this.method_45988((class_2248)block, this.method_45984((class_2248)block, (class_1935)TinkerCommons.slimeball.get((SlimeType)((Object)slime)), (class_5658)class_44.method_32448((float)4.0f))));
        TinkerWorld.slimeDirt.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46025(arg_0));
        TinkerWorld.vanillaSlimeGrass.forEach(block -> this.method_45988((class_2248)block, this.method_45983((class_2248)block, (class_1935)class_2246.field_10566)));
        TinkerWorld.earthSlimeGrass.forEach(block -> this.method_45988((class_2248)block, this.method_45983((class_2248)block, (class_1935)TinkerWorld.slimeDirt.get(SlimeType.EARTH))));
        TinkerWorld.skySlimeGrass.forEach(block -> this.method_45988((class_2248)block, this.method_45983((class_2248)block, (class_1935)TinkerWorld.slimeDirt.get(SlimeType.SKY))));
        TinkerWorld.enderSlimeGrass.forEach(block -> this.method_45988((class_2248)block, this.method_45983((class_2248)block, (class_1935)TinkerWorld.slimeDirt.get(SlimeType.ENDER))));
        TinkerWorld.ichorSlimeGrass.forEach(block -> this.method_45988((class_2248)block, this.method_45983((class_2248)block, (class_1935)TinkerWorld.slimeDirt.get(SlimeType.ICHOR))));
        TinkerWorld.slimeSapling.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46025(arg_0));
        TinkerWorld.pottedSlimeSapling.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46023(arg_0));
        TinkerWorld.pottedSlimeFern.forEach(arg_0 -> ((BlockLootTableProvider)this).method_46023(arg_0));
        TinkerWorld.slimeTallGrass.forEach(block -> this.method_45994((class_2248)block, BlockLootTableProvider::onlyShears));
        for (SlimeType type2 : SlimeType.OVERWORLD) {
            this.method_45994(TinkerWorld.slimeLeaves.get(type2), block -> this.randomDropSlimeBallOrSapling(type2, (class_2248)block, TinkerWorld.slimeSapling.get(type2), field_40605));
            this.method_45994((class_2248)TinkerWorld.slimeFern.get(type2), BlockLootTableProvider::onlyShears);
        }
        for (SlimeType type2 : SlimeType.NETHER) {
            this.method_46025(TinkerWorld.slimeLeaves.get(type2));
            this.method_46025((class_2248)TinkerWorld.slimeFern.get(type2));
        }
        this.method_45994((class_2248)TinkerWorld.skySlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.method_45994((class_2248)TinkerWorld.enderSlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.registerWoodLootTables(TinkerWorld.greenheart);
        this.registerWoodLootTables(TinkerWorld.skyroot);
        this.registerWoodLootTables(TinkerWorld.bloodshroom);
        this.registerGeode(TinkerWorld.earthGeode);
        this.registerGeode(TinkerWorld.skyGeode);
        this.registerGeode(TinkerWorld.ichorGeode);
        this.registerGeode(TinkerWorld.enderGeode);
    }

    private void addGadgets() {
        this.method_46025(TinkerGadgets.punji.get());
        TinkerGadgets.cake.forEach(block -> this.method_45988((class_2248)block, BlockLootTableProvider.method_45975()));
        this.method_45988((class_2248)TinkerGadgets.magmaCake.get(), BlockLootTableProvider.method_45975());
    }

    private void addSmeltery() {
        this.method_46025(TinkerSmeltery.grout.get());
        this.method_46025(TinkerSmeltery.searedMelter.get());
        this.method_46025(TinkerSmeltery.searedHeater.get());
        this.dropTable(TinkerSmeltery.smelteryController.get());
        this.registerBuildingLootTables(TinkerSmeltery.searedStone);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedCobble);
        this.registerBuildingLootTables(TinkerSmeltery.searedPaver);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedBricks);
        this.method_46025(TinkerSmeltery.searedCrackedBricks.get());
        this.method_46025(TinkerSmeltery.searedFancyBricks.get());
        this.method_46025(TinkerSmeltery.searedTriangleBricks.get());
        this.method_46025(TinkerSmeltery.searedLadder.get());
        this.method_46025(TinkerSmeltery.searedGlass.get());
        this.method_46025((class_2248)TinkerSmeltery.searedGlassPane.get());
        this.dropTable(TinkerSmeltery.searedDrain.get());
        this.dropTable(TinkerSmeltery.searedChute.get());
        this.dropTable(TinkerSmeltery.searedDuct.get());
        Function<class_2248, class_52.class_53> dropTank = block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023)).method_438((class_117.class_118)class_3837.method_16848((class_5651)class_5646.field_27914).method_16856("tank", "tank")));
        TinkerSmeltery.searedTank.forEach(block -> this.method_45994((class_2248)block, dropTank));
        this.method_45994((class_2248)TinkerSmeltery.searedLantern.get(), dropTank);
        this.method_46025(TinkerSmeltery.searedFaucet.get());
        this.method_46025(TinkerSmeltery.searedChannel.get());
        this.method_46025(TinkerSmeltery.searedBasin.get());
        this.method_46025(TinkerSmeltery.searedTable.get());
    }

    private void addFoundry() {
        this.method_46025(TinkerSmeltery.netherGrout.get());
        this.method_46025(TinkerSmeltery.scorchedAlloyer.get());
        this.dropTable(TinkerSmeltery.foundryController.get());
        this.method_46025(TinkerSmeltery.scorchedStone.get());
        this.method_46025(TinkerSmeltery.polishedScorchedStone.get());
        this.registerFenceBuildingLootTables(TinkerSmeltery.scorchedBricks);
        this.method_46025(TinkerSmeltery.chiseledScorchedBricks.get());
        this.registerBuildingLootTables(TinkerSmeltery.scorchedRoad);
        this.method_46025(TinkerSmeltery.scorchedLadder.get());
        this.method_46025(TinkerSmeltery.scorchedGlass.get());
        this.method_46025((class_2248)TinkerSmeltery.scorchedGlassPane.get());
        this.dropTable(TinkerSmeltery.scorchedDrain.get());
        this.dropTable(TinkerSmeltery.scorchedChute.get());
        this.dropTable(TinkerSmeltery.scorchedDuct.get());
        Function<class_2248, class_52.class_53> dropTank = block -> this.droppingWithFunctions((class_2248)block, builder -> builder.method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023)).method_438((class_117.class_118)class_3837.method_16848((class_5651)class_5646.field_27914).method_16856("tank", "tank")));
        TinkerSmeltery.scorchedTank.forEach(block -> this.method_45994((class_2248)block, dropTank));
        this.method_45994((class_2248)TinkerSmeltery.scorchedLantern.get(), dropTank);
        this.method_46025(TinkerSmeltery.scorchedFaucet.get());
        this.method_46025(TinkerSmeltery.scorchedChannel.get());
        this.method_46025(TinkerSmeltery.scorchedBasin.get());
        this.method_46025(TinkerSmeltery.scorchedTable.get());
    }

    protected static class_52.class_53 onlyShears(class_1935 item) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(SHEARS).method_351((class_79.class_80)class_77.method_411((class_1935)item)));
    }

    private static class_52.class_53 droppingSilkOrShears(class_2248 block, class_79.class_80<?> alternativeLootEntry) {
        return BlockLootTableProvider.method_45991((class_2248)block, (class_5341.class_210)SILK_TOUCH_OR_SHEARS, alternativeLootEntry);
    }

    private class_52.class_53 dropSapling(class_2248 blockIn, class_2248 saplingIn, float ... fortuneIn) {
        return BlockLootTableProvider.droppingSilkOrShears(blockIn, ((class_85.class_86)this.method_45978((class_1935)blockIn, (class_192)class_77.method_411((class_1935)saplingIn))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])fortuneIn)));
    }

    private class_52.class_53 randomDropSlimeBallOrSapling(SlimeType foliageType, class_2248 blockIn, class_2248 sapling, float ... fortuneIn) {
        return this.dropSapling(blockIn, sapling, fortuneIn).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(field_40607).method_351(((class_85.class_86)this.method_45978((class_1935)blockIn, (class_192)class_77.method_411((class_1935)((class_1935)TinkerCommons.slimeball.get(foliageType))))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.05f}))));
    }

    private class_52.class_53 droppingWithFunctions(class_2248 block, Function<class_85.class_86<?>, class_85.class_86<?>> mapping) {
        return class_52.method_324().method_336((class_55.class_56)this.method_45978((class_1935)block, (class_192)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)mapping.apply(class_77.method_411((class_1935)block)))));
    }

    private void registerBuildingLootTables(BuildingBlockObject object) {
        this.method_46025((class_2248)object.get());
        this.method_45994((class_2248)object.getSlab(), arg_0 -> ((BlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025((class_2248)object.getStairs());
    }

    private void registerWallBuildingLootTables(WallBuildingBlockObject object) {
        this.registerBuildingLootTables(object);
        this.method_46025((class_2248)object.getWall());
    }

    private void registerFenceBuildingLootTables(FenceBuildingBlockObject object) {
        this.registerBuildingLootTables(object);
        this.method_46025((class_2248)object.getFence());
    }

    private void registerWoodLootTables(WoodBlockObject object) {
        this.registerFenceBuildingLootTables(object);
        this.method_46025(object.getLog());
        this.method_46025(object.getStrippedLog());
        this.method_46025(object.getWood());
        this.method_46025(object.getStrippedWood());
        this.method_46025((class_2248)object.getFenceGate());
        this.method_45994((class_2248)object.getDoor(), arg_0 -> ((BlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025((class_2248)object.getTrapdoor());
        this.method_46025((class_2248)object.getPressurePlate());
        this.method_46025((class_2248)object.getButton());
        this.method_46025((class_2248)object.getSign());
    }

    private void dropTable(class_2248 table) {
        this.method_45994(table, this.ADD_TABLE);
    }

    private void registerGeode(GeodeItemObject geode) {
        this.method_46025(geode.getBlock());
        this.method_45994(geode.getBud(GeodeItemObject.BudSize.CLUSTER), block -> BlockLootTableProvider.method_45989((class_2248)block, (class_79.class_80)((class_85.class_86)class_77.method_411(geode.get()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)4.0f))).method_438((class_117.class_118)class_94.method_455((class_1887)class_1893.field_9130)).method_421(class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8975(class_3489.field_29544)))).method_417((class_79.class_80)this.method_45977((class_1935)block, (class_116)class_77.method_411(geode.get()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)))))));
        for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.SIZES) {
            this.method_46024(geode.getBud(size));
        }
        this.method_45988(geode.getBudding(), BlockLootTableProvider.method_45975());
    }
}

